/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.render.CrossPortalEntityRenderer;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyBuiltChunkStorage;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.VisibleSectionDiscovery;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

@Mixin(value={LevelRenderer.class})
public abstract class MixinLevelRenderer
implements IEWorldRenderer {
    @Shadow
    private ClientLevel f_109465_;
    @Shadow
    @Final
    private EntityRenderDispatcher f_109463_;
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    private ViewArea f_109469_;
    @Shadow
    private ChunkRenderDispatcher f_109436_;
    @Shadow
    private PostChain f_109418_;
    @Mutable
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    private int f_109438_;
    @Shadow
    @Nullable
    private RenderTarget f_109413_;
    @Shadow
    private Frustum f_172938_;
    @Shadow
    @Nullable
    private VertexBuffer f_109471_;
    @Shadow
    @Nullable
    private VertexBuffer f_109472_;
    @Shadow
    @Nullable
    private VertexBuffer f_109473_;
    @Shadow
    @Nullable
    private VertexBuffer f_109475_;
    @Mutable
    @Shadow
    @Final
    private ObjectArrayList<LevelRenderer.RenderChunkInfo> f_194297_;

    @Shadow
    protected abstract void m_109517_(Entity var1, double var2, double var4, double var6, float var8, PoseStack var9, MultiBufferSource var10);

    @Shadow
    protected abstract void m_109834_();

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;constantAmbientLight()Z")})
    private void onAfterCutoutRendering(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        CrossPortalEntityRenderer.onBeginRenderingEntities(matrices);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Sheets;translucentCullBlockSheet()Lnet/minecraft/client/renderer/RenderType;")})
    private void onMyBeforeTranslucentRendering(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        IPCGlobal.renderer.onBeforeTranslucentRendering(matrices);
        MyGameRenderer.updateFogColor();
        MyGameRenderer.resetFogState();
        MyGameRenderer.resetDiffuseLighting(matrices);
        FrontClipping.disableClipping();
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endLastBatch()V", ordinal=1, shift=At.Shift.AFTER)})
    private void onEndRenderingEntities(PoseStack poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        CrossPortalEntityRenderer.onEndRenderingEntities(poseStack);
    }

    @Inject(method={"renderLevel"}, at={@At(value="RETURN")})
    private void onAfterTranslucentRendering(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        IPCGlobal.renderer.onAfterTranslucentRendering(matrices);
        Lighting.m_252756_((Matrix4f)matrices.m_85850_().m_252922_());
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderChunkLayer(Lnet/minecraft/client/renderer/RenderType;Lcom/mojang/blaze3d/vertex/PoseStack;DDDLorg/joml/Matrix4f;)V")})
    private void onBeforeRenderingLayer(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), matrices.m_85850_().m_252922_(), -0.01);
            if (PortalRendering.isRenderingOddNumberOfMirrors()) {
                MyRenderHelper.applyMirrorFaceCulling();
            }
            if (IPGlobal.enableDepthClampForPortalRendering) {
                CHelper.enableDepthClamp();
            }
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderChunkLayer(Lnet/minecraft/client/renderer/RenderType;Lcom/mojang/blaze3d/vertex/PoseStack;DDDLorg/joml/Matrix4f;)V", shift=At.Shift.AFTER)})
    private void onAfterRenderingLayer(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
            MyRenderHelper.recoverFaceCulling();
            if (IPGlobal.enableDepthClampForPortalRendering) {
                CHelper.disableDepthClamp();
            }
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetupTerrainBegin(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (WorldRenderInfo.isRendering() && this.f_109465_.m_46472_() != RenderStates.originalPlayerDimension) {
            this.f_109436_.m_112693_(camera.m_90583_());
        }
        if (this.ip_allowOverrideTerrainSetup() && WorldRenderInfo.isRendering()) {
            this.f_109465_.m_46473_().m_6180_("ip_terrain_setup");
            VisibleSectionDiscovery.discoverVisibleSections(this.f_109465_, (MyBuiltChunkStorage)this.f_109469_, camera, new Frustum(frustum).m_194441_(8), this.f_194297_);
            this.f_109465_.m_46473_().m_7238_();
            ci.cancel();
        }
    }

    private boolean ip_allowOverrideTerrainSetup() {
        return !SodiumInterface.invoker.isSodiumPresent() && !IrisInterface.invoker.isRenderingShadowMap();
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at={@At(value="RETURN")}, cancellable=true)
    private void onSetupTerrainEnd(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (!WorldRenderInfo.isRendering() && this.ip_allowOverrideTerrainSetup()) {
            if (MyGameRenderer.vanillaTerrainSetupOverride > 0) {
                --MyGameRenderer.vanillaTerrainSetupOverride;
                this.f_109465_.m_46473_().m_6180_("ip_terrain_setup");
                VisibleSectionDiscovery.discoverVisibleSections(this.f_109465_, (MyBuiltChunkStorage)this.f_109469_, camera, new Frustum(frustum).m_194441_(8), this.f_194297_);
                this.f_109465_.m_46473_().m_7238_();
            } else if (IPGlobal.alwaysOverrideTerrainSetup) {
                this.f_109465_.m_46473_().m_6180_("ip_terrain_setup_debug");
                VisibleSectionDiscovery.discoverVisibleSections(this.f_109465_, (MyBuiltChunkStorage)this.f_109469_, camera, new Frustum(frustum).m_194441_(8), this.f_194297_);
                this.f_109465_.m_46473_().m_7238_();
            }
        }
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V", remap=false))
    private void redirectClearing(int int_1, boolean boolean_1) {
        if (!IPCGlobal.renderer.replaceFrameBufferClearing()) {
            RenderSystem.clear((int)int_1, (boolean)boolean_1);
        }
    }

    @Redirect(method={"allChanged"}, at=@At(value="NEW", target="net/minecraft/client/renderer/ViewArea"))
    private ViewArea redirectConstructingBuildChunkStorage(ChunkRenderDispatcher chunkBuilder_1, Level world_1, int int_1, LevelRenderer worldRenderer_1) {
        if (IPCGlobal.useHackedChunkRenderDispatcher) {
            return new MyBuiltChunkStorage(chunkBuilder_1, world_1, int_1, worldRenderer_1);
        }
        return new ViewArea(chunkBuilder_1, world_1, int_1, worldRenderer_1);
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"))
    private void redirectRenderEntity(LevelRenderer worldRenderer, Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        CrossPortalEntityRenderer.beforeRenderingEntity(entity, matrixStack);
        this.m_109517_(entity, cameraX, cameraY, cameraZ, tickDelta, matrixStack, vertexConsumerProvider);
        CrossPortalEntityRenderer.afterRenderingEntity(entity);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V")})
    private void beforeRenderingWeather(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), matrices.m_85850_().m_252922_(), 0.0);
            RenderStates.isRenderingPortalWeather = true;
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V", shift=At.Shift.AFTER)})
    private void afterRenderingWeather(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
            RenderStates.isRenderingPortalWeather = false;
        }
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;shouldEntityAppearGlowing(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean redirectGlowing(Minecraft client, Entity entity) {
        if (WorldRenderInfo.isRendering()) {
            return false;
        }
        return client.m_91314_(entity);
    }

    @Inject(method={"allChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void onReloadStarted(CallbackInfo ci) {
        if (WorldRenderInfo.isRendering()) {
            Helper.log("world renderer reloading cancelled during portal rendering");
            ci.cancel();
        }
    }

    @Inject(method={"allChanged"}, at={@At(value="TAIL")})
    private void onReloadFinished(CallbackInfo ci) {
        LevelRenderer this_ = (LevelRenderer)this;
        if (ClientWorldLoader.getIsCreatingClientWorld()) {
            return;
        }
        Validate.isTrue((Minecraft.m_91087_().f_91060_ == this_ ? 1 : 0) != 0);
        ClientWorldLoader._onWorldRendererReloaded();
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderSkyBegin(PoseStack poseStack, Matrix4f matrix4f, float partialTick, Camera camera, boolean isFoggy, Runnable runnable, CallbackInfo ci) {
        if (WorldRenderInfo.isRendering() && !WorldRenderInfo.getTopRenderInfo().doRenderSky && !IrisInterface.invoker.isShaders()) {
            ci.cancel();
        }
        if (PortalRendering.isRenderingOddNumberOfMirrors()) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="RETURN")})
    private void onRenderSkyEnd(PoseStack poseStack, Matrix4f matrix4f, float f, Camera camera, boolean bl, Runnable runnable, CallbackInfo ci) {
        MyRenderHelper.recoverFaceCulling();
    }

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 redirectGetEyePositionInSkyRendering(LocalPlayer player, float partialTicks) {
        if (WorldRenderInfo.isRendering()) {
            return WorldRenderInfo.getCameraPos();
        }
        return player.m_20299_(partialTicks);
    }

    @Inject(method={"prepareCullFrustum"}, at={@At(value="HEAD")})
    private void onSetupFrustum(PoseStack matrices, Vec3 pos, Matrix4f projectionMatrix, CallbackInfo ci) {
        TransformationManager.processTransformation(this.f_109461_.f_91063_.m_109153_(), matrices);
    }

    @Redirect(method={"renderLevel"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;translucentTarget:Lcom/mojang/blaze3d/pipeline/RenderTarget;"))
    private RenderTarget redirectTranslucentFramebuffer(LevelRenderer this_) {
        if (PortalRendering.isRendering()) {
            return null;
        }
        return this.f_109413_;
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1)
    private boolean modifyIsSpectator(boolean value) {
        if (WorldRenderInfo.isRendering()) {
            return true;
        }
        return value;
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;pollLightUpdates()V"))
    private void redirectRunQueuedChunkUpdates(ClientLevel world) {
        ClientWorldLoader.withSwitchedWorld(world, () -> ((ClientLevel)world).m_194141_());
    }

    @Inject(method={"isChunkCompiled"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsChunkCompiled(BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        ViewArea viewArea;
        if (PortalRendering.isRendering() && !SodiumInterface.invoker.isSodiumPresent() && (viewArea = this.f_109469_) instanceof MyBuiltChunkStorage) {
            MyBuiltChunkStorage myBuiltChunkStorage = (MyBuiltChunkStorage)viewArea;
            cir.setReturnValue((Object)this.ip_isChunkCompiled(myBuiltChunkStorage, blockPos));
        }
    }

    private boolean ip_isChunkCompiled(MyBuiltChunkStorage myBuiltChunkStorage, BlockPos blockPos) {
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)blockPos);
        ChunkRenderDispatcher.RenderChunk renderChunk = myBuiltChunkStorage.rawGet(sectionPos.m_123170_(), sectionPos.m_123206_(), sectionPos.m_123222_());
        return renderChunk != null && renderChunk.f_112784_.get() != ChunkRenderDispatcher.CompiledChunk.f_112748_;
    }

    @Override
    public EntityRenderDispatcher ip_getEntityRenderDispatcher() {
        return this.f_109463_;
    }

    @Override
    public ViewArea ip_getBuiltChunkStorage() {
        return this.f_109469_;
    }

    @Override
    public ChunkRenderDispatcher getChunkBuilder() {
        return this.f_109436_;
    }

    @Override
    public void ip_myRenderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        this.m_109517_(entity, cameraX, cameraY, cameraZ, tickDelta, matrixStack, vertexConsumerProvider);
    }

    @Override
    public PostChain portal_getTransparencyShader() {
        return this.f_109418_;
    }

    @Override
    public void portal_setTransparencyShader(PostChain arg) {
        this.f_109418_ = arg;
    }

    @Override
    public RenderBuffers ip_getRenderBuffers() {
        return this.f_109464_;
    }

    @Override
    public void ip_setRenderBuffers(RenderBuffers arg) {
        this.f_109464_ = arg;
    }

    @Override
    public Frustum portal_getFrustum() {
        return this.f_172938_;
    }

    @Override
    public void portal_setFrustum(Frustum arg) {
        this.f_172938_ = arg;
    }

    @Override
    public void portal_fullyDispose() {
        this.m_109834_();
        if (this.f_109471_ != null) {
            this.f_109471_.close();
        }
        if (this.f_109472_ != null) {
            this.f_109472_.close();
        }
        if (this.f_109473_ != null) {
            this.f_109473_.close();
        }
        if (this.f_109475_ != null) {
            this.f_109475_.close();
        }
        this.f_109465_ = null;
    }

    @Override
    public void portal_setChunkInfoList(ObjectArrayList<LevelRenderer.RenderChunkInfo> arg) {
        this.f_194297_ = arg;
    }

    @Override
    public ObjectArrayList<LevelRenderer.RenderChunkInfo> portal_getChunkInfoList() {
        return this.f_194297_;
    }
}

